<?php

/*

* 2007-2012 PrestaShop

*

* NOTICE OF LICENSE

*

* This source file is subject to the Academic Free License (AFL 3.0)

* that is bundled with this package in the file LICENSE.txt.

* It is also available through the world-wide-web at this URL:

* http://opensource.org/licenses/afl-3.0.php

* If you did not receive a copy of the license and are unable to

* obtain it through the world-wide-web, please send an email

* to license@prestashop.com so we can send you a copy immediately.

*

* DISCLAIMER

*

* Do not edit or add to this file if you wish to upgrade PrestaShop to newer

* versions in the future. If you wish to customize PrestaShop for your

* needs please refer to http://www.prestashop.com for more information.

*

*  @author PrestaShop SA <contact@prestashop.com>

*  @copyright  2007-2012 PrestaShop SA

*  @version  Release: $Revision: 6844 $

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

*  International Registered Trademark & Property of PrestaShop SA

*/



if (!defined('_PS_VERSION_'))

	exit;

	

class Blockomicronsocial extends Module

{

	public $omicronadv_title;

	

	/* Title associated to the image */

	public $omicronadv_title2;

	

	public $omicronadv_content2;

	

	/* Link associated to the image */

	public $omicronadv_link2;

	



	

	/* Title associated to the image */

	public $omicronadv_title3;

	

	public $omicronadv_content3;

	

	/* Link associated to the image */

	public $omicronadv_link3;

	

	public $facebook_url;

	public $googleplus_url;

	public $pinterest_url;

	public $youtube_url;

	public $twitter_url;

	public $in_url;

	

	

	public function __construct()

	{

		$this->name = 'blockomicronsocial';

		$this->tab = 'front_office_features';

		$this->version = '1.0';

		$this->author = 'DigitalOmicron';

		$this->need_instance = 0;



		parent::__construct();



		$this->displayName = $this->l('Block social');

		$this->description = $this->l('Allows you to add extra information about social networks');

		$this->initialize();

	}

	

	/*

	 * Set the properties of the module, like the link to the image and the title (contextual to the current shop context)

	 */

	protected function initialize()

	{

		/*

	 * First block image

	 */

		$this->omicronadv_title = htmlentities(Configuration::get('BLOCKOMICRONADVERT_TITLE'), ENT_QUOTES, 'UTF-8');



		

	/*

	 * Second block image

	 */	

		$this->omicronadv_link2 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_LINK2'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_title2 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_TITLE2'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_content2 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_CONTENT2'), ENT_QUOTES, 'UTF-8');

		

		

		

		/*

	 * Third block image

	 */	

		

		$this->omicronadv_link3 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_LINK3'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_title3 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_TITLE3'), ENT_QUOTES, 'UTF-8');

		$this->omicronadv_content3 = htmlentities(Configuration::get('BLOCKOMICRONADVERT_CONTENT3'), ENT_QUOTES, 'UTF-8');

		

		

		/*

		* Social Media 

		



		*/

		$this->facebook_url = htmlentities(Configuration::get('blockomicronsocial_facebook'), ENT_QUOTES, 'UTF-8');

		$this->googleplus_url = htmlentities(Configuration::get('blockomicronsocial_googleplus'), ENT_QUOTES, 'UTF-8');

		$this->pinterest_url = htmlentities(Configuration::get('blockomicronsocial_pinterest'), ENT_QUOTES, 'UTF-8');

		$this->youtube_url = htmlentities(Configuration::get('blockomicronsocial_youtube'), ENT_QUOTES, 'UTF-8');

		$this->twitter_url = htmlentities(Configuration::get('blockomicronsocial_twitter'), ENT_QUOTES, 'UTF-8');

		$this->in_url = htmlentities(Configuration::get('blockomicronsocial_in'), ENT_QUOTES, 'UTF-8');

	}

	

	public function install()

	{

		return (parent::install() AND 



		/*

	 * First block image

	 */	

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_TITLE', 'Connect with us on') && 

		

		/*

	 * Second block image

	 */	

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_LINK2', 'http://www.prestashop.com/') && 

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_TITLE2', 'Free Shipping on orders over $99') && 

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_CONTENT2', 'Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.') && 

		/*

	 * Third block image

	 */	

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_LINK3', 'http://www.prestashop.com/') &&

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_TITLE3', 'Online Support') &&

		Configuration::updateGlobalValue('BLOCKOMICRONADVERT_CONTENT3', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.') &&

		

		Configuration::updateGlobalValue('blockomicronsocial_facebook', 'http://www.facebook.com/') &&

		Configuration::updateGlobalValue('blockomicronsocial_googleplus', 'http://www.facebook.com/') &&

		Configuration::updateGlobalValue('blockomicronsocial_pinterest', 'http://www.pinterest.com/') &&

		Configuration::updateGlobalValue('blockomicronsocial_youtube', 'http://www.facebook.com/') &&

		Configuration::updateGlobalValue('blockomicronsocial_twitter', 'http://www.facebook.com/') &&

		Configuration::updateGlobalValue('blockomicronsocial_in', 'http://www.facebook.com/') &&

		

		$this->registerHook('displayHeader') && $this->registerHook('footerAdvt'));

		

	}

	

	public function uninstall()

	{

		//Delete configuration			

	

		Configuration::deleteByName('blockomicronsocial_facebook');

		Configuration::deleteByName('blockomicronsocial_googleplus'); 

		Configuration::deleteByName('blockomicronsocial_pinterest');

		Configuration::deleteByName('blockomicronsocial_youtube');

		Configuration::deleteByName('blockomicronsocial_twitter');

		Configuration::deleteByName('blockomicronsocial_in'); 

		Configuration::deleteByName('BLOCKOMICRONADVERT_TITLE');

		

		Configuration::deleteByName('BLOCKOMICRONADVERT_LINK2');

		Configuration::deleteByName('BLOCKOMICRONADVERT_TITLE2'); 

		Configuration::deleteByName('BLOCKOMICRONADVERT_CONTENT2');

		

		Configuration::deleteByName('BLOCKOMICRONADVERT_LINK3'); 

		Configuration::deleteByName('BLOCKOMICRONADVERT_TITLE3'); 

		Configuration::deleteByName('BLOCKOMICRONADVERT_CONTENT3'); 



		

		return (parent::uninstall());

	}

	

	public function postProcess()

	{

		$errors = '';

		if (Tools::isSubmit('submitAdvConf'))

		{

					

				

				// If the link is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($link2 = Tools::getValue('omicronadv_link2'))

				Configuration::updateValue('BLOCKOMICRONADVERT_LINK2', $link2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_LINK2');

				

				

			// If the link is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($link3 = Tools::getValue('omicronadv_link3'))

				Configuration::updateValue('BLOCKOMICRONADVERT_LINK3', $link3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_LINK3');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title = Tools::getValue('omicronadv_title'))

				Configuration::updateValue('BLOCKOMICRONADVERT_TITLE', $title);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_TITLE');

				

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title2 = Tools::getValue('omicronadv_title2'))

				Configuration::updateValue('BLOCKOMICRONADVERT_TITLE2', $title2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_TITLE2');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($title3 = Tools::getValue('omicronadv_title3'))

				Configuration::updateValue('BLOCKOMICRONADVERT_TITLE3', $title3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_TITLE3');

				

			

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($content2 = Tools::getValue('omicronadv_content2'))

				Configuration::updateValue('BLOCKOMICRONADVERT_CONTENT2', $content2);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_CONTENT2');

				

			// If the title is not set, then delete it in order to use the next default value (either the global value or the group value)

			if ($content3 = Tools::getValue('omicronadv_content3'))

				Configuration::updateValue('BLOCKOMICRONADVERT_CONTENT3', $content3);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('BLOCKOMICRONADVERT_CONTENT3');

				

				

			if ($link = Tools::getValue('facebook_url'))

				Configuration::updateValue('blockomicronsocial_facebook', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_facebook');

				

			if ($link = Tools::getValue('googleplus_url'))

				Configuration::updateValue('blockomicronsocial_googleplus', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_googleplus');

				

				

			if ($link = Tools::getValue('pinterest_url'))

				Configuration::updateValue('blockomicronsocial_pinterest', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_pinterest');

				

				

			if ($link = Tools::getValue('youtube_url'))

				Configuration::updateValue('blockomicronsocial_youtube', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_youtube');

			

			if ($link = Tools::getValue('twitter_url'))

				Configuration::updateValue('blockomicronsocial_twitter', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_twitter');

				

			if ($link = Tools::getValue('in_url'))

				Configuration::updateValue('blockomicronsocial_in', $link);

			elseif (Shop::getContext() == Shop::CONTEXT_SHOP || Shop::getContext() == Shop::CONTEXT_GROUP)

				Configuration::deleteFromContext('blockomicronsocial_in');

			

			// Reset the module properties

			$this->initialize();

			$this->_clearCache('blockomicronsocial.tpl');

		}

		if ($errors)

			echo $this->displayError($errors);

		

	}

	

	public function getContent()

	{

		// If we try to update the settings

		$this->postProcess();

		

		$output = '

		<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/admin.css" />

		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">

			<fieldset>

				<legend>'.$this->l('Advertising block configuration').'</legend>';

					

			$output .= '<br/><br/>

<div class="omicron_social">

	<fieldset>	<legend> First Block </legend>			





				<label for="omicronadv_title" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title" type="text" name="omicronadv_title" value="'.$this->omicronadv_title.'" style="width:250px" />

					

				</div>

					<label for="facebook_url" style="float:left; width:auto;">'.$this->l('Facebook URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="facebook_url" name="facebook_url" value="'.$this->facebook_url.'"  style="width:250px" />

				<div class="clear">&nbsp;</div>	

				</div>

				

				<label for="twitter_url" style="float:left; width:auto;">'.$this->l('Twitter URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="twitter_url" name="twitter_url" value="'.$this->twitter_url.'"  style="width:250px" />

				<div class="clear">&nbsp;</div>			

				</div>

				<label for="pinterest_url" style="float:left; width:auto;">'.$this->l('pinterest URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="pinterest_url" name="pinterest_url" value="'.$this->pinterest_url.'"  style="width:250px" />

				<div class="clear">&nbsp;</div>		

				</div>

				

				<label for="googleplus_url" style="float:left; width:auto;">'.$this->l('Googleplus URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="googleplus_url" name="googleplus_url" value="'.$this->googleplus_url.'"  style="width:250px" />

				<div class="clear">&nbsp;</div>	

				</div>

				

				<label for="youtube_url" style="float:left; width:auto;">'.$this->l('Youtube URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="youtube_url" name="youtube_url" value="'.$this->youtube_url.'"  style="width:250px" />

				<div class="clear">&nbsp;</div>		

				</div>

				

					

				<label for="in_url" style="float:left; width:auto;">'.$this->l('in URL: ').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input type="text" id="in_url" name="in_url" value="'.$this->in_url.'"  style="width:250px" />

				</div>



			

</fieldset>					



<fieldset>	<legend> Second Block </legend>

	



			

				<label for="omicronadv_title2" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title2" type="text" name="omicronadv_title2" value="'.$this->omicronadv_title2.'" style="width:250px" />

				</div>

				<label for="omicronadv_content2" style="float:left; width:auto;">'.$this->l('Caption').'</label>

				<div class="margin-form" style="padding-left:120px;">

				<input id="omicronadv_content2" type="text" name="omicronadv_content2" value="'.$this->omicronadv_content2.'" style="width:250px" />

					</div>

				

				<label for="omicronadv_link2" style="float:left; width:auto;">'.$this->l('link').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_link2" type="text" name="omicronadv_link2" value="'.$this->omicronadv_link2.'" style="width:250px" />

				</div>

				<br class="clear"/>

				

</fieldset>					

<fieldset>	<legend> Third Block </legend>			



		

		

			<label for="omicronadv_title3" style="float:left; width:auto;">'.$this->l('Title').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_title3" type="text" name="omicronadv_title3" value="'.$this->omicronadv_title3.'" style="width:250px" />

				</div>

				<label for="omicronadv_content3" style="float:left; width:auto;">'.$this->l('Caption').'</label>

				<div class="margin-form" style="padding-left:120px;">

					

					<input id="omicronadv_content3" type="text" name="omicronadv_content3" value="'.$this->omicronadv_content3.'" style="width:250px" />

				</div>

					<label for="omicronadv_link3" style="float:left; width:auto;">'.$this->l('link').'</label>

				<div class="margin-form" style="padding-left:120px;">

					<input id="omicronadv_link3" type="text" name="omicronadv_link3" value="'.$this->omicronadv_link3.'" style="width:250px" />

				</div>

					

							



	</fieldset>				

</div>												

					<br class="clear"/>	

				<br /><center><input class="button" type="submit" name="submitAdvConf" value="'.$this->l('Validate').'"/></center>';

		

				$output .= '

				

				

				<br class="clear"/>

				

				

				

				

			</fieldset>

		</form>';

		return $output;



	}

	

			

	public function hookFooterAdvt()

	{

			

		if (!$this->isCached('blockomicronsocial.tpl', $this->getCacheId()))

			$this->smarty->assign(array(

			

			

				'facebook_url' => $this->facebook_url,

			'twitter_url' => $this->twitter_url,

			'pinterest_url' => $this->pinterest_url,

			'youtube_url' => $this->youtube_url,

			'googleplus_url' => $this->googleplus_url,

			'in_url' => $this->in_url,



				

				'omicronadv_title' => $this->omicronadv_title,



				

			

				'omicronadv_link2' => $this->omicronadv_link2,

				'omicronadv_title2' => $this->omicronadv_title2,

				'omicronadv_content2' => $this->omicronadv_content2,

				

				

				'omicronadv_link3' => $this->omicronadv_link3,

				'omicronadv_title3' => $this->omicronadv_title3,

				'omicronadv_content3' => $this->omicronadv_content3

			));



		return $this->display(__FILE__, 'blockomicronsocial.tpl', $this->getCacheId());

	}

	

	public function hookLeftColumn($params)

	{

		return $this->hookFooterAdvt($params);

	}



	public function hookHeader($params)

	{

		$this->context->controller->addCSS($this->_path.'blockomicronadvt.css', 'all');

		$this->context->controller->addCSS($this->_path.'blockomicronsocial.css', 'all');

	}

}

?>

